﻿//////////////////////////////////////////////
// DecodedMeshData.h
//
//////////////////////////////////////////////

/// Defines / Macros -------------------------

#pragma once

/// Includes ---------------------------------

// nkGraphics
#include "../../Dll/DllDefines.h"

#include "../../Meshes/Enums/IndexFormat.h"
#include "../../Meshes/Enums/PrimitiveTopology.h"

#include "../../Meshes/InputLayouts/MeshInputLayout.h"

// nkMemory
#include <NilkinsMemory/Containers/Buffer.h>
#include <NilkinsMemory/Containers/BufferCast.h>

/// Class ------------------------------------

namespace nkGraphics
{
	struct DLL_GRAPHICS_EXPORT DecodedMeshData final
	{
		// Attributes
		nkMemory::BufferCast<nkMemory::Buffer> _vertexBuffers ;
		nkMemory::Buffer _indexBuffer ;

		MeshInputLayout _inputLayout ;

		unsigned int _vertexCount = 0u ;
		unsigned int _indexCount = 0u ;

		INDEX_FORMAT _indexFormat = INDEX_FORMAT::UINT32 ;
		PRIMITIVE_TOPOLOGY _topology = PRIMITIVE_TOPOLOGY::TRIANGLELIST ;
	} ;
}